/*
  Image to agb 15-bit raw file converter.  Will convert any
  Imlib2 supported file to a raw Width x Hheight 15-bit agb
  bitmap.  Useful for splash screens.

  This is program is licensed under the GPL.
  */

#include <X11/Xlib.h>
#include <Imlib2.h>
#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

typedef struct {
    unsigned char b;
    unsigned char g;
    unsigned char r;
    unsigned char a;
} color;

int main(int argc, char **argv)
{
    int src_width, src_height;
    int x, y;
    short v;
    color *c;
    Imlib_Image image;
    int fd;
    DATA32 *in;

    if (argc == 3) {
	image = imlib_load_image(argv[1]);
	imlib_context_set_image(image);
//   in = imlib_image_get_data();
	in = imlib_image_get_data_for_reading_only();
	src_width = imlib_image_get_width();
	src_height = imlib_image_get_height();

	fd = creat(argv[2], 0666);
	for (y = 0; y < src_height; y++)
	    for (x = 0; x < src_width; x++) {
		c = (color *) (in + x + y * src_width);
		v = (((c->b) >> 3) << 10) +
		    (((c->g) >> 3) << 5) + ((c->r) >> 3);
		write(fd, &v, sizeof(short));
	    }
	close(fd);

	return 0;
    } else {
	printf("Usage: %s <file.(img)> <file.raw>\n", argv[0]);
	return 1;
    }
}
